// ContentsEscC.cpp : CContentsEscC Class source code
//

#include "stdafx.h"
#include "defsfile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL(CContentsEscC, CObject, 1)



// Serialize draw data
void CContentsEscC::Serialize(CArchive& ar)
{
    CObject::Serialize(ar);

    if (ar.IsStoring ())
        ar.Write(&m_Data,sizeof(m_Data)) ;
    else
        ar.Read(&m_Data,sizeof(m_Data)) ;
}

// Draw to Window
void CContentsEscC::Draw(CDC* pDC)
{
	CGpWinPen Pen( m_Data.cDisplayColor,0) ;
	CPen *pOldPen = pDC->SelectObject((CPen* )&Pen);

	int OldBkMode = pDC->SetBkMode( OPAQUE );
	COLORREF OldBkColor   = pDC->SetBkColor(GpToWinColor(m_Data.cBackColor));

	int x1,y1,x2,y2 ;
	x1 = m_Data.iX1 - m_Data.iRadius ; y1 = m_Data.iY1 - m_Data.iRadius ;
	x2 = m_Data.iX1 + m_Data.iRadius ; y2 = m_Data.iY1 + m_Data.iRadius ;
	pDC->Arc(x1,y1,x2,y2, x2,m_Data.iY1,x2,m_Data.iY1);


	pDC->SetBkMode( OldBkMode );
	pDC->SetBkColor( OldBkColor );
	pDC->SelectObject(pOldPen);
}

// Transmit the data to GP
int CContentsEscC::Transition( CMemSock* pCMemSock)
{
	return( pCMemSock->MtoMESC_C(m_Data.cDisplayColor,m_Data.cBackColor,m_Data.cLineStyle,m_Data.iX1,m_Data.iY1,m_Data.iRadius)) ;
}
